/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.apps.viewer;

import filenet.sim.apps.viewer.VWSIMAnimatorCore;
import filenet.sim.apps.viewer.images.VWSIMImageLoader;
import filenet.sim.apps.viewer.resources.VWSIMResource;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWLogger;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWBaseLaunchableApplication;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWSplashWindow;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Dimension;

public class VWSIMAnimatorApplication
extends VWBaseLaunchableApplication
implements IVWSplashWindowListener {
    private VWSIMAnimatorCore m_animatorCore = null;
    private VWSplashWindow m_splashWindow = null;

    public static void main(String[] argv) {
        try {
            VWDebug.init(VWLogger.ERROR);
            VWCommandLineArgs args = new VWCommandLineArgs(argv);
            VWSessionInfo sessionInfo = new VWSessionInfo(null, null, args);
            if (!sessionInfo.verifyLogon(null)) {
                System.exit(1);
            }
            VWSIMAnimatorApplication pApp = new VWSIMAnimatorApplication();
            pApp.init(sessionInfo);
            VWSIMHelp.init(pApp);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void init(VWSessionInfo sessionInfo) {
        try {
            super.init(sessionInfo);
            try {
                this.setIconImage(VWSIMImageLoader.createImageIcon("animator.gif").getImage());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.m_splashWindow = new VWSplashWindow(this);
            String title = null;
            try {
                title = VWIDMBaseFactory.instance().getVWString(13).toString();
            }
            catch (Exception ex) {
                title = VWSIMResource.s_animatorTitle;
            }
            this.setTitle(title);
            if (!this.updatePosition("animator_location", "animator_size")) {
                Dimension dim = VWStringUtils.stringToDimension("800,600");
                if (dim == null) {
                    dim = new Dimension(800, 600);
                }
                this.updatePosition(dim.width, dim.height);
            }
            this.show();
            this.m_animatorCore = new VWSIMAnimatorCore();
            this.m_animatorCore.createAnimationThread();
            if (this.m_splashWindow != null) {
                this.m_splashWindow.start(this, 250);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void startProcessing() {
        block4: {
            if (this.m_animatorCore == null) {
                return;
            }
            try {
                this.m_animatorCore.setSplashWindow(this.m_splashWindow);
                this.m_animatorCore.init(this.m_sessionInfo);
                this.m_splashWindow = null;
                String simulationName = this.m_animatorCore.getSimulationName();
                if (simulationName != null && simulationName.length() > 0) {
                    this.setTitle(VWSIMResource.s_titleAndSimulationName.toString(this.getTitle(), simulationName));
                }
            }
            catch (Exception ex) {
                this.m_splashWindow = null;
                VWDebug.logException(ex);
                if (this.m_animatorCore == null) break block4;
                this.m_animatorCore.exitApplication();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean destroy() {
        boolean bExit = true;
        try {
            if (this.m_animatorCore != null) {
                bExit = this.m_animatorCore.doExit();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            if (bExit) {
                try {
                    this.finalize();
                }
                catch (Throwable throwable) {}
                this.dispose();
                super.destroy();
                this.m_splashWindow = null;
                this.m_animatorCore = null;
                System.runFinalization();
                System.gc();
            }
        }
        return bExit;
    }
}

